function processedImage = postProcess(segmentedImage, fgScribblesMask, bgScribblesMask)
%POSTPROCESS Postprocessing to the segmented image
% It removes small islands and returns only connected components that are
% reachable from foreground scribbles
%
%   Input:
%       segmentedImage: binary image representing the output segmentation
%       fgSribblesMask: binary mask representing input foreground scribbles
%       bgSribblesMask: binary mask representing input background scribbles
% 
%   Output:
%       processedImage: binary image representing the output segmentation
%       after post-processing
%
% (c) Moustafa Meshry, moustafa.meshry@alexu.edu.eg
%     Department of Compter and Systems Engineering, Alexandria University, Egypt.

    segmentedImage(fgScribblesMask) = 255;
    segmentedImage(bgScribblesMask) = 0;
    processedImage = getConnectedComponentsWithSeed(...
        segmentedImage, fgScribblesMask);
    processedImage = imfill(processedImage, 'holes');
    processedImage = processedImage - getConnectedComponentsWithSeed(...
        ~segmentedImage, bgScribblesMask);
    processedImage = max(processedImage, 0);
end

